/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class CSVRecord
implements Collection {
    public static final boolean TRIM = true;
    public static final boolean NO_TRIM = false;
    public static final String COMMA = ",";
    private static final char QUOTE = '\"';
    private static final char LINEFEED = '\n';
    private Vector m_container = new Vector();
    private boolean m_trim = false;
    private String m_delimiter = ",";

    public CSVRecord() {
    }

    public CSVRecord(boolean bl) {
        this.m_trim = bl;
    }

    public CSVRecord(boolean bl, String string) {
        this.m_trim = bl;
        this.m_delimiter = string;
    }

    public CSVRecord(String string) {
        this(string, false, COMMA);
    }

    public CSVRecord(String string, boolean bl) {
        this(string, bl, COMMA);
    }

    public CSVRecord(String string, String string2) {
        this(string, false, string2);
    }

    public CSVRecord(String string, boolean bl, String string2) {
        this.m_trim = bl;
        this.m_delimiter = string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, true);
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = null;
            string3 = bl ? stringTokenizer.nextToken().trim() : stringTokenizer.nextToken();
            if (string3.equals(string2)) {
                if (!this.hasOddQuotes(stringBuffer.toString())) {
                    if (stringBuffer.length() > 0 && stringBuffer.charAt(0) == '\"') {
                        stringBuffer.deleteCharAt(0);
                        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
                    }
                    this.m_container.add(CSVRecord.parseCSVCell(stringBuffer.toString(), string2));
                    stringBuffer = new StringBuffer("");
                    continue;
                }
                stringBuffer.append(string3);
                continue;
            }
            stringBuffer.append(string3);
        }
        if (string.endsWith(string2)) {
            this.m_container.add(new String(""));
        } else {
            this.m_container.add(CSVRecord.parseCSVCell(stringBuffer.toString(), string2));
        }
    }

    private final int countQuotes(String string) {
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != '\"') continue;
            ++n;
        }
        return n;
    }

    private final boolean hasOddQuotes(String string) {
        return this.countQuotes(string) % 2 == 1;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.m_container.size();
        if (n > 0) {
            stringBuffer.append(CSVRecord.makeCSVCell((String)this.m_container.get(0), this.m_delimiter));
        }
        for (int i = 1; i < n; ++i) {
            stringBuffer.append(this.m_delimiter);
            stringBuffer.append(CSVRecord.makeCSVCell((String)this.m_container.get(i), this.m_delimiter));
        }
        return stringBuffer.toString();
    }

    private Collection objectsToStrings(Collection collection) {
        Vector<String> vector = new Vector<String>(collection.size());
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            if (this.m_trim) {
                vector.add(iterator.next().toString().trim());
                continue;
            }
            vector.add(iterator.next().toString());
        }
        return vector;
    }

    public static final String makeCSVCell(String string) {
        return CSVRecord.makeCSVCell(string, COMMA);
    }

    public static final String makeCSVCell(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(34, n)) != -1) {
            stringBuffer.insert(n + n2, '\"');
            ++n2;
            ++n;
        }
        if (n2 != 0 || string.indexOf(10) != -1 || string.indexOf(string2) != -1) {
            stringBuffer.insert(0, '\"');
            stringBuffer.append('\"');
        }
        return stringBuffer.toString();
    }

    public static final String parseCSVCell(String string) {
        return CSVRecord.parseCSVCell(string, COMMA);
    }

    public static final String parseCSVCell(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(34, n)) != -1) {
            stringBuffer.deleteCharAt(n + n2);
            n += 2;
            --n2;
        }
        return stringBuffer.toString();
    }

    public static final void append(CSVRecord cSVRecord, String string, String string2, boolean bl) {
        if (bl) {
            cSVRecord.add(string + "=" + string2);
        } else if (string2 != null) {
            cSVRecord.add(string2);
        } else {
            cSVRecord.add("null");
        }
    }

    public static final void append(CSVRecord cSVRecord, String string, Number number, boolean bl) {
        if (number == null) {
            CSVRecord.append(cSVRecord, string, (String)null, bl);
        } else {
            CSVRecord.append(cSVRecord, string, number.toString(), bl);
        }
    }

    public static final void append(CSVRecord cSVRecord, String string, Boolean bl, boolean bl2) {
        if (bl == null) {
            CSVRecord.append(cSVRecord, string, (String)null, bl2);
        } else {
            CSVRecord.append(cSVRecord, string, bl.toString(), bl2);
        }
    }

    public boolean add(Object object) {
        if (this.m_trim) {
            return this.m_container.add(object.toString().trim());
        }
        return this.m_container.add(object.toString());
    }

    public boolean addAll(Collection collection) {
        return this.m_container.addAll(this.objectsToStrings(collection));
    }

    public void clear() {
        this.m_container.clear();
    }

    public boolean contains(Object object) {
        if (this.m_trim) {
            return this.m_container.contains(object.toString().trim());
        }
        return this.m_container.contains(object.toString());
    }

    public boolean containsAll(Collection collection) {
        return this.m_container.containsAll(this.objectsToStrings(collection));
    }

    public boolean isEmpty() {
        return this.m_container.isEmpty();
    }

    public Iterator iterator() {
        return this.m_container.iterator();
    }

    public boolean remove(Object object) {
        if (this.m_trim) {
            return this.m_container.remove(object.toString().trim());
        }
        return this.m_container.remove(object.toString());
    }

    public boolean removeAll(Collection collection) {
        return this.m_container.removeAll(this.objectsToStrings(collection));
    }

    public boolean retainAll(Collection collection) {
        return this.m_container.retainAll(this.objectsToStrings(collection));
    }

    public int size() {
        return this.m_container.size();
    }

    public Object[] toArray() {
        return this.m_container.toArray();
    }

    public Object[] toArray(Object[] objectArray) {
        return this.m_container.toArray(objectArray);
    }

    public Vector getContainer() {
        return this.m_container;
    }
}

